<?php
// Connexion BDD
$dsn = 'mysql:host=localhost;dbname=easysystem3000_pinpo;charset=utf8mb4';
$user = 'easysystem3000_pinpo';
$password = '1vt.(Ym[xc5v';

try {
    $pdo = new PDO($dsn, $user, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    exit("Erreur BDD : " . $e->getMessage());
}

// Lecture JSON
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    exit('Données JSON invalides');
}
$logs = 'Logs/webhook_log'.date("H:i:s").'.txt';
// Log pour debug
file_put_contents($logs, print_r($data, true), FILE_APPEND);

// Récupération externalId
$externalId = $data['externalId'] ?? null;
if (!$externalId) {
    
    http_response_code(400);
    exit('externalId manquant');
}
file_put_contents('webhook_log.txt',"-----------------------".$logs."-----------------------\n", FILE_APPEND);
file_put_contents('webhook_log.txt',"External Id: ".$externalId."\n", FILE_APPEND);
// Recherche prospect_id
$stmt = $pdo->prepare("SELECT id FROM prospects WHERE external_id = :external_id");
$stmt->execute(['external_id' => $externalId]);
$prospect = $stmt->fetch(PDO::FETCH_ASSOC);
file_put_contents('webhook_log.txt',"Prospect: ".json_encode($prospect,true)."\n", FILE_APPEND);
if (!$prospect) {
    http_response_code(404);
    exit("Aucun prospect trouvé avec l'externalId : $externalId");
}

$prospectId = $prospect['id'];

// Préparation des données conversation
$pinpoId = $data['id'] ?? null;
$status = $data['insightPinpo']['details'][4]['value'] ?? 'Clôturée'; // fallback
$lastMessage = $data['report']['conversationDisplay'] ?? '';
$lastUpdated = $data['lastActivity'] ?? null;
$isSynced = 1;

// Vérifie si la conversation existe déjà
$stmtCheck = $pdo->prepare("SELECT id FROM conversations WHERE pinpo_conversation_id = :pinpo_id");
$stmtCheck->execute(['pinpo_id' => $pinpoId]);
$existing = $stmtCheck->fetch(PDO::FETCH_ASSOC);
file_put_contents('webhook_log.txt',"Conversation Exist: ".json_encode($existing,true)."\n", FILE_APPEND);
if ($existing) {
    // Mise à jour
    $stmt = $pdo->prepare("
        UPDATE conversations SET
            prospect_id = :prospect_id,
            status = :status,
            last_message = :last_message,
            last_updated_at = :last_updated_at,
            is_synced = :is_synced
        WHERE pinpo_conversation_id = :pinpo_id
    ");
} else {
    // Insertion
    $stmt = $pdo->prepare("
        INSERT INTO conversations (
            prospect_id, pinpo_conversation_id, status, last_message, last_updated_at, is_synced
        ) VALUES (
            :prospect_id, :pinpo_id, :status, :last_message, :last_updated_at, :is_synced
        )
    ");
}

$stmt->execute([
    'prospect_id' => $prospectId,
    'pinpo_id' => $pinpoId,
    'status' => $status,
    'last_message' => $lastMessage,
    'last_updated_at' => date('Y-m-d H:i:s', strtotime($lastUpdated)),
    'is_synced' => $isSynced
]);

http_response_code(200);
echo "Conversation enregistrée.";
?>
